/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CcLinkSlave_Functionlist.h $
   Last Modification:
    $Id: CcLinkSlave_Functionlist.h 36726 2013-07-19 09:28:58Z Eric $

    $Author: Eric $
    $Modtime: 14.01.09 9:16 $
    $Revision: 7 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CcLink Slave
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     8          26.08.10    ES
       Added external references to the XC codings

     7          07.10.08    ES
        Increased parameter version
        Added parameter for pool packet count and queue size
        Added definition for default pool packet count and queue size

     3          13.01.09    ES
        Increased parameter version
        Added configuration parameter for xC names and default definitions

     2          31.10.07    ES
        Created

**************************************************************************************/
/**
 * @file CcLinkSlave_Functionlist.h
 * @brief CcLink Slave - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_CcLinkSlave</code>
 * of task.
 */
#ifndef __CCLINK_SLAVE_FUNCTIONLIST_H
#define __CCLINK_SLAVE_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_VOID
TaskExit_CcLinkSlave
(
 TLR_VOID FAR* pvRsc
);

TLR_VOID
TaskEnter_CcLinkSlave
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define CCLINK_SLAVE_STARTUP_PARAM_VERSION_3 (3)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct CCLINK_SLAVE_STARTUPPARAMETER_Ttag  CCLINK_SLAVE_STARTUPPARAMETER_T;

#define CCLINK_SLAVE_MIN_CYCLETIME    1
#define CCLINK_SLAVE_MAX_CYCLETIME    100

#define CCLINK_SLAVE_XC_INST_0        0
#define CCLINK_SLAVE_XC_INST_1        1
#define CCLINK_SLAVE_XC_INST_2        2
#define CCLINK_SLAVE_XC_INST_3        3

/*Default xC names*/
#define CCLINK_SLAVE_XC_COM_IRQ_NAME  "CCS_COM"
#define CCLINK_SLAVE_XC_XPEC_NAME     "CCS_XPEC"
#define CCLINK_SLAVE_XC_RPEC_NAME     "CCS_RPEC"
#define CCLINK_SLAVE_XC_XMACRPU_NAME  "CCS_XMACRPU"
#define CCLINK_SLAVE_XC_XMACTPU_NAME  "CCS_XMACTPU"

#define CCLINK_SLAVE_QUEUE_MIN_ELEM   8
#define CCLINK_SLAVE_QUEUE_DEF_ELEM   32
#define CCLINK_SLAVE_QUEUE_MAX_ELEM   64

#define CCLINK_SLAVE_POOL_MIN_ELEM    8
#define CCLINK_SLAVE_POOL_DEF_ELEM    32
#define CCLINK_SLAVE_POOL_MAX_ELEM    64

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct CCLINK_SLAVE_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  /** Task identifier*/
  TLR_UINT32 ulTaskIdentifier;
  /** Parameter version*/
  TLR_UINT32 ulParamVersion;
  /** Cycle Time */
  TLR_UINT32  ulCycleTime;
  /** XC Instance */
  TLR_UINT32  ulXcInst;
  STRING      szComIrqName[16];
  STRING      szXpecName[16];
  STRING      szXmacRpuName[16];
  STRING      szXmacTpuName[16];
  /** Queue element count*/
  TLR_UINT32 ulQueueElem;
  /** Pool element count*/
  TLR_UINT32 ulPoolElem;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __CCLINK_SLAVE_FUNCTIONLIST_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/
